/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.mrp3;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import cz.insophy.inplan.mrp3.ActiveSetGetter;
import cz.insophy.inplan.mrp3.AlternativeSelector;
import cz.insophy.inplan.mrp3.Balancer;
import cz.insophy.inplan.mrp3.Demand;
import cz.insophy.inplan.mrp3.EsaSupply;
import cz.insophy.inplan.mrp3.Events;
import cz.insophy.inplan.mrp3.GorSupply;
import cz.insophy.inplan.mrp3.MatEvent;
import cz.insophy.inplan.mrp3.SrSupply;
import cz.insophy.inplan.mrp3.Supply;
import cz.insophy.inplan.mrp3.SupplyVisitor;
import cz.insophy.inplan.shop.Actiongram;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.util.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mrp {
    private final Superplan superplan;
    private final AlternativeSelector alternativeSelector;
    private final ActiveSetGetter activeSetGetter;
    private final Balancer balancer;

    public Mrp(@Nonnull Superplan superplan, AlternativeSelector alternativeSelector, ActiveSetGetter activeSetGetter, Balancer balancer) {
        this.superplan = Preconditions.checkNotNull(superplan);
        this.alternativeSelector = alternativeSelector;
        this.activeSetGetter = activeSetGetter;
        this.balancer = balancer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result run() {
        Map<GeneralizedOrderRequest, Actiongram> selectedAlternatives = this.alternativeSelector.selectAlternatives(this.superplan);
        ArrayListMultimap<Material, Supply> unresolvedSupplies = ArrayListMultimap.create();
        ArrayListMultimap<Material, Demand> unresolvedDemands = ArrayListMultimap.create();
        try {
            this.selectAlternatives(selectedAlternatives);
            ArrayList<Supply> finalSupplies = Lists.newArrayList();
            for (Material m3 : this.activeSetGetter.getActiveSet(this.superplan)) {
                Tuple<Collection<Supply>, Events> result = this.balancer.balanceMaterial(this.superplan, m3, new Events(unresolvedSupplies.get(m3), unresolvedDemands.get(m3)));
                finalSupplies.addAll(result.getFirst());
                unresolvedSupplies.removeAll(m3);
                unresolvedDemands.removeAll(m3);
                unresolvedSupplies.putAll(Multimaps.index(result.getSecond().supplies, MatEvent::getMaterial));
                unresolvedDemands.putAll(Multimaps.index(result.getSecond().demands, MatEvent::getMaterial));
            }
            Result result = new Result(selectedAlternatives, finalSupplies, unresolvedSupplies, unresolvedDemands);
            return result;
        }
        finally {
            this.unselectAlternatives(selectedAlternatives);
        }
    }

    private void selectAlternatives(Map<GeneralizedOrderRequest, Actiongram> selectedAlternatives) {
        for (Map.Entry<GeneralizedOrderRequest, Actiongram> entry : selectedAlternatives.entrySet()) {
            GeneralizedOrderRequest gor = entry.getKey();
            Actiongram ag = entry.getValue();
            if (gor.getSuperplan() != this.superplan) {
                throw new IllegalStateException();
            }
            gor.setActiongram(ag);
        }
    }

    private void unselectAlternatives(Map<GeneralizedOrderRequest, Actiongram> selectedAlternatives) {
        for (Map.Entry<GeneralizedOrderRequest, Actiongram> entry : selectedAlternatives.entrySet()) {
            GeneralizedOrderRequest gor = entry.getKey();
            if (gor.getSuperplan() != this.superplan) {
                throw new IllegalStateException();
            }
            gor.cancelActiongram();
        }
    }

    public static class Result {
        private static final Logger LOG = LoggerFactory.getLogger(Result.class);
        private final Map<GeneralizedOrderRequest, Actiongram> selectedActiongrams;
        private final Collection<Supply> finalSupplies;
        private final Multimap<Material, Supply> unresolvedSupplies;
        private final Multimap<Material, Demand> unresolvedDemands;

        private Result(Map<GeneralizedOrderRequest, Actiongram> selectedActiongrams, Collection<Supply> finalSupplies, Multimap<Material, Supply> unresolvedSupplies, Multimap<Material, Demand> unresolvedDemands) {
            this.selectedActiongrams = selectedActiongrams;
            this.finalSupplies = finalSupplies;
            this.unresolvedSupplies = unresolvedSupplies;
            this.unresolvedDemands = unresolvedDemands;
        }

        public Map<GeneralizedOrderRequest, Actiongram> getSelectedActiongrams() {
            return this.selectedActiongrams;
        }

        public Actiongram getSelectedActiongram(GeneralizedOrderRequest gor) {
            return this.selectedActiongrams.get(gor);
        }

        public Collection<Supply> getFinalSupplies() {
            return this.finalSupplies;
        }

        public Collection<Supply> getUnresolvedSupplies() {
            return this.unresolvedSupplies.values();
        }

        public Collection<Supply> getUnresolvedSupplies(Material matprod) {
            return this.unresolvedSupplies.get(matprod);
        }

        public Collection<Demand> getUnresolvedDemands() {
            return this.unresolvedDemands.values();
        }

        public Collection<Demand> getUnresolvedDemands(Material matprod) {
            return this.unresolvedDemands.get(matprod);
        }

        public void apply(final Superplan superplan) {
            LOG.info("Applying MRP result to superplan...");
            LOG.info("Setting alternatives...");
            for (Map.Entry<GeneralizedOrderRequest, Actiongram> entry : this.selectedActiongrams.entrySet()) {
                GeneralizedOrderRequest gor = entry.getKey();
                Actiongram ag = entry.getValue();
                if (gor.getSuperplan() != superplan) {
                    throw new IllegalStateException("GOR " + gor + " is not in the superplan.");
                }
                gor.setActiongram(ag);
            }
            LOG.info("Setting alternatives finished.");
            LOG.info("Inserting supplies...");
            for (Supply supply : this.finalSupplies) {
                supply.accept(new SupplyVisitor<Void>(){

                    @Override
                    public Void visit(EsaSupply supply) {
                        throw new IllegalStateException("Attempted to insert ESA supply which is forbidden.");
                    }

                    @Override
                    public Void visit(SrSupply supply) {
                        if (!supply.isBound()) {
                            throw new IllegalStateException("Supply " + supply + " is to be added to the superplan but is not bound.");
                        }
                        superplan.addSupplyRequest(supply.getSr());
                        return null;
                    }

                    @Override
                    public Void visit(GorSupply supply) {
                        if (!supply.isBound()) {
                            throw new IllegalStateException("Supply " + supply + " is to be added to the superplan but is not bound.");
                        }
                        superplan.addGor(supply.getGor());
                        return null;
                    }
                });
            }
            LOG.info("Inserting supplies finished.");
            LOG.info("MRP result applied to the superplan.");
        }
    }
}

